% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetTrajectories.R
\name{subsetTrajectories}
\alias{subsetTrajectories}
\title{Trajectory subsetting}
\usage{
subsetTrajectories(
  x,
  site_selection = NULL,
  subtrajectory_selection = NULL,
  survey_selection = NULL
)
}
\arguments{
\item{x}{An object of class \code{trajectories} (or its children subclasses \code{fd.trajectories} or \code{cycles})}

\item{site_selection}{A character vector indicating the subset of entity (site) trajectories to be selected (if NULL, all sites are included).}

\item{subtrajectory_selection}{A character vector indicating the subset of cycles or fixed date trajectories to be selected (only used when \code{x} is of class \code{fd.trajectories} or \code{cycles}).}

\item{survey_selection}{An integer vector indicating the subset of surveys to be included (if NULL, all surveys are included).}
}
\value{
An object (list) of class \code{trajectories} (or its children subclasses \code{fd.trajectories} or \code{cycles}), depending on the input.
}
\description{
Subsets data structures for trajectory analysis
}
\details{
When using function \code{subsetTrajectories} on cycles or fixed-date trajectories then the parameter \code{site_selection} applies to sites
(hence allows selecting multiple cycles or fixed-date trajectories). Specific cycles or fixed-date trajectories can be selected using \code{trajectory_selection}.
}
\examples{
#Description of entities (sites) and surveys
entities <- c("1","1","1","2","2","2")
surveys <- c(1,2,3,1,2,3)
  
#Raw data table
xy<-matrix(0, nrow=6, ncol=2)
xy[2,2]<-1
xy[3,2]<-2
xy[4:6,1] <- 0.5
xy[4:6,2] <- xy[1:3,2]
xy[6,1]<-1

d <- dist(xy)

# Defines trajectories
x <- defineTrajectories(d, entities, surveys)
x

# Extracts (subset) second trajectory
x_2 <- subsetTrajectories(x, "2")
x_2
}
\seealso{
\code{\link{defineTrajectories}}, \code{\link{trajectoryCyclical}}
}
