% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid3d.R
\name{e_axis_3d}
\alias{e_axis_3d}
\alias{e_x_axis_3d}
\alias{e_y_axis_3d}
\alias{e_z_axis_3d}
\title{Axis 3D}
\usage{
e_axis_3d(e, axis = c("x", "y", "z"), index = 0, ...)

e_x_axis_3d(e, index = 0, ...)

e_y_axis_3d(e, index = 0, ...)

e_z_axis_3d(e, index = 0, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{axis}{Axis to customise.}

\item{index}{Index of axis to customise.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Customise 3D axis.
}
\examples{
# phony data
v <- LETTERS[1:10]
matrix <- data.frame(
  x = sample(v, 300, replace = TRUE),
  y = sample(v, 300, replace = TRUE),
  z1 = rnorm(300, 10, 1),
  z2 = rnorm(300, 10, 1),
  stringsAsFactors = FALSE
) |>
  dplyr::group_by(x, y) |>
  dplyr::summarise(
    z1 = sum(z1),
    z2 = sum(z2)
  ) |>
  dplyr::ungroup()

trans <- list(opacity = 0.4) # transparency
emphasis <- list(itemStyle = list(color = "#313695"))

matrix |>
  e_charts(x) |>
  e_bar_3d(y, z1, stack = "stack", name = "Serie 1", itemStyle = trans, emphasis = emphasis) |>
  e_bar_3d(y, z2, stack = "stack", name = "Serie 2", itemStyle = trans, emphasis = emphasis) |>
  e_x_axis_3d(axisLine = list(lineStyle = list(color = "blue")))
}
\seealso{
\href{https://echarts.apache.org/en/option-gl.html#xAxis3D}{Additional x arguments},
 \href{https://echarts.apache.org/en/option-gl.html#yAxis3D}{Additional y arguments},
 \href{https://echarts.apache.org/en/option-gl.html#zAxis3D}{Additional z arguments}
}
