# Generated by 02-duckplyr_df-methods.R
#' @rdname intersect.duckplyr_df
#' @export
intersect.duckplyr_df <- function(x, y, ...) {
  # Our implementation
  check_dots_empty()
  check_compatible(x, y)

  x_names <- names(x)
  y_names <- names(y)
  if (identical(x_names, y_names)) {
    # Ensure identical() is very cheap
    y_names <- x_names
  }

  duckplyr_error <- rel_try(list(name = "intersect", x = x, y = y),
    #' @section Fallbacks:
    #' There is no DuckDB translation in `intersect.duckplyr_df()`
    #' - if column names are duplicated in one of the tables,
    #' - if column names are different in both tables.
    #'
    #' These features fall back to [dplyr::intersect()], see `vignette("fallback")` for details.
    "No duplicate names" = !identical(x_names, y_names) && anyDuplicated(x_names) && anyDuplicated(y_names),
    "Tables of different width" = length(x_names) != length(y_names),
    "Name mismatch" = !identical(x_names, y_names) && !all(y_names %in% x_names),
    {
      if (oo_force()) {
        both <- semi_join(x, y, by = x_names)
        out <- distinct(both)
      } else {
        x_rel <- duckdb_rel_from_df(x)
        y_rel <- duckdb_rel_from_df(y)
        if (!identical(x_names, y_names)) {
          # FIXME: Select by position
          exprs <- nexprs_from_loc(x_names, set_names(seq_along(x_names), x_names))
          y_rel <- rel_project(y_rel, exprs)
        }

        rel <- rel_set_intersect(x_rel, y_rel)
        out <- duckplyr_reconstruct(rel, x)
      }
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  intersect <- dplyr$intersect.data.frame
  out <- intersect(x, y, ...)
  return(out)

  # dplyr implementation
  check_dots_empty()
  check_compatible(x, y)

  out <- vec_set_intersect(x, y, error_call = current_env())

  dplyr_reconstruct(out, x)
}

duckplyr_intersect <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df_impl(x)
      y <- as_duckplyr_df_impl(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- intersect(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
