% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dead_functions.R
\name{dsm.cor}
\alias{dsm.cor}
\title{Check for autocorrelation in residuals}
\usage{
dsm.cor(
  dsm.obj,
  Transect.Label = "Transect.Label",
  Segment.Label = "Segment.Label",
  max.lag = 10,
  resid.type = "scaled.pearson",
  fun = cor,
  ylim = c(0, 1),
  subset = "all",
  ...
)
}
\arguments{
\item{dsm.obj}{a fitted dsm object.}

\item{Transect.Label}{label for the transect (default: \code{Transect.Label}).
Using different labels can be useful when transects are split over
geographical features or when transects are surveyed multiple times.}

\item{Segment.Label}{label for the segments (default: \code{Segment.Label}).The
result of calling \code{\link[base:order]{order}} must make sense.}

\item{max.lag}{maximum lag to calculate at.}

\item{resid.type}{the type of residuals used, see
\code{\link{residuals.gam}}. Defaults to \code{"scaled.pearson"} in the GAM
case and \code{"normalized"} in the GAMM case (which are equivalent).}

\item{fun}{the function to use, by default \code{\link[stats:cor]{cor}}, must take two
column vectors as arguments.}

\item{ylim}{user defined limits in y direction.}

\item{subset}{which subset of the data should the correlation function be
calculated on?}

\item{...}{other options to pass to \code{\link[base:plot]{plot}}.}
}
\description{
This function is deprecated, use \link{dsm_cor}.
}
