% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{make_decisions}
\alias{make_decisions}
\title{Human-friendly interface to the drug prep algorithm}
\usage{
make_decisions(
  implausible_qty,
  missing_qty,
  implausible_ndd,
  missing_ndd,
  implausible_duration,
  calculate_duration,
  missing_duration,
  clash_start,
  overlapping,
  small_gaps
)
}
\arguments{
\item{implausible_qty}{implausible total drug quantities}

\item{missing_qty}{missing total drug quantities}

\item{implausible_ndd}{implausible daily dosage}

\item{missing_ndd}{missing daily dosage}

\item{implausible_duration}{overly-long prescription durations}

\item{calculate_duration}{formula or variable to compute prescription duration}

\item{missing_duration}{missing prescription duration}

\item{clash_start}{how to disambiguate prescriptions that start on the same date}

\item{overlapping}{how to handle prescription periods that overlap with one another}

\item{small_gaps}{how to handle short gaps between successive prescriptions

The argument \code{decision_phrases} may contain the following terms (without brackets, separated with spaces).
Additional or incorrectly-named elements will be ignored.
\describe{
\item{implausible_qty}{(ignore|missing|mean|median|mode|next|previous) (individual|practice|population)}
\item{implausible_ndd}{(ignore|missing|mean|median|mode|next|previous) (individual|practice|population)}
\item{implausible_duration}{(ignore|missing|truncate) (6|12|24)}
\item{missing_qty}{(ignore|mean|median|mode|next|previous) (individual|practice|population)}
\item{missing_ndd}{(ignore|mean|median|mode|next|previous) (individual|practice|population)}
\item{missing_duration}{(ignore|mean) (individual|population|both)}
\item{calculate_duration}{(numdays|dose_duration|qty/ndd)}
\item{clash_start}{(ignore|mean|shortest|longest|sum)}
\item{overlapping}{(allow|shift)}
\item{small_gaps}{(ignore|close) (15|30|60)}
}}
}
\value{
A character vector suitable for passing to the \code{decisions} argument of
the \code{\link{drug_prep}} function.
}
\description{
A helper function that allows specifying decision rules using English
words rather than alphanumeric codes. Translates the rules into the
corresponding codes and then passes them to \code{\link{drug_prep}} functions.
}
\examples{
make_decisions('ignore',
               'mean population',
               'missing',
               'mean practice',
               'truncate 6',
               'qty / ndd',
               'mean individual',
               'mean',
               'allow',
               'close 15')

}
