% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twomode_Redunancy.R
\name{netstats_tm_redundancy}
\alias{netstats_tm_redundancy}
\title{Compute Burchard and Cornwell's (2018) Two-Mode Redundancy}
\usage{
netstats_tm_redundancy(
  net,
  inParallel = FALSE,
  nCores = NULL,
  isolates = NA,
  weighted = FALSE
)
}
\arguments{
\item{net}{A two-mode adjacency matrix or affiliation matrix.}

\item{inParallel}{TRUE/FALSE. TRUE indicates that parallel processing will be used to compute the statistic with the \emph{foreach} package. FALSE indicates that parallel processing will not be used. Set to FALSE by default.}

\item{nCores}{If inParallel = TRUE, the number of computing cores for parallel processing. If this value is not specified, then the function internally provides it by dividing the number of available cores in half.}

\item{isolates}{What value should isolates be given? Preset to be NA.}

\item{weighted}{TRUE/FALSE. TRUE indicates the resulting statistic will be based on the weighted formula (see the details section). FALSE indicates the statistic will be based on the original non-weighted formula. Set to FALSE by default.}
}
\value{
An \emph{n x n} matrix with level 1 redundancy scores for actors in a two-mode network.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function calculates the values for two mode redundancy
for weighted and unweighted two-mode networks based on Burchard and Cornwell (2018).
}
\details{
The formula for two-mode redundancy is:
\deqn{r_{ij} = \frac{|\sigma(j) \cap \sigma(i)|}{|\sigma(i)|}}
where:
\itemize{
\item \eqn{r_{ij}} is the redundancy of ego \emph{i} with respect to actor \emph{j}.
\item \eqn{|\sigma(j) \cap \sigma(i)|} is the number of same-class contacts (e.g., medical doctors in a hospital) that \emph{i} and \emph{j} both share.
\item \eqn{|\sigma(i)|} is the number of same-class contacts of ego \emph{i}.
}
The two-mode redundancy is ego-bound, that is, the redundancy is only based on the
two-mode ego network of \emph{i}. Put differently, \eqn{r_{ij}} only considers the perspective of the ego.
This function allows the user to compute the scores in parallel through the \emph{foreach} and \emph{doParallel} R packages.
If the matrix is weighted, the user should specify \emph{weighted = TRUE}. Following Burchard and Cornwell (2018),
the formula for two-mode weighted redundancy is:
\deqn{r_{ij} = \frac{|\sigma(j) \cap \sigma(i)|}{|\sigma(i)| \times w_t}}
where \eqn{w_t} is the average of the tie weights that \emph{i} and \emph{j} send
to their shared opposite class contacts.
}
\examples{

# For this example, we recreate Figure 2 in Burchard and Cornwell (2018: 13)
BCNet <- matrix(
 c(1,1,0,0,
   1,0,1,0,
   1,0,0,1,
   0,1,1,1),
 nrow = 4, ncol = 4, byrow = TRUE)
colnames(BCNet) <- c("1", "2", "3", "4")
rownames(BCNet) <- c("i", "j", "k", "m")
#this values replicate those reported by Burchard and Cornwell (2018: 14)
netstats_tm_redundancy(BCNet)


#For this example, we recreate Figure 9 in Burchard and Cornwell (2018:18)
#for weighted two mode networks.
BCweighted <- matrix(c(1,2,1, 1,0,0,
                      0,2,1,0,0,1),
                      nrow = 4, ncol = 3,
                      byrow = TRUE)
rownames(BCweighted) <- c("i", "j", "k", "l")
netstats_tm_redundancy(BCweighted, weighted = TRUE)


}
\references{
Burchard, Jake and Benjamin Cornwell. 2018. "Structural Holes and bridging
in two-mode networks." \emph{Social Networks} 55:11-20.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
