% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_temporal.R
\name{temp.beta}
\alias{temp.beta}
\title{Temporal beta diversity calculation for raster}
\usage{
temp.beta(bin1, bin2, tree, filename = "", cores = 1, ...)
}
\arguments{
\item{bin1}{A SpatRaster with presence-absence data (0 or 1)
for a set of species.}

\item{bin2}{A SpatRaster with presence-absence data (0 or 1)
for a set of species. Species names in 'bin2' and 'bin1' must
match!}

\item{tree}{It can be a 'data.frame' with species traits or a
'phylo' with a rooted phylogenetic tree. Species names in 'tree',
'bin1', and 'bin2' must match!}

\item{filename}{Character. Save results if a name is provided.}

\item{cores}{A positive integer. If cores > 1, a 'parallel'
package cluster with that many cores is created and used.}

\item{...}{Additional arguments to be passed passed down from
a calling function.}
}
\value{
A SpatRaster with beta results (total, replacement,
richness difference, and ratio).
}
\description{
Calculates temporal beta diversity for
taxonomic (TD), functional (FD), and phylogenetic (PD)
dimensions. Adapted from \code{\link[BAT]{beta}}
}
\details{
The TD beta diversity partitioning framework we used
was developed by Podani and Schmera (2011) and Carvalho et al.
(2012) and expanded to PD and FD by Cardoso et al. (2014).
}
\examples{
\donttest{
library(terra)
bin1 <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
bin2 <- terra::rast(system.file("extdata", "fut.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
tree <- ape::read.tree(system.file("extdata", "tree.tre",
package = "divraster"))
temp.beta(bin1, bin2)
temp.beta(bin1, bin2, traits)
temp.beta(bin1, bin2, tree)
}
}
\references{
Cardoso, P. et al. 2014. Partitioning taxon,
phylogenetic and functional beta diversity into replacement
and richness difference components. - Journal of Biogeography
41: 749–761.

Carvalho, J. C. et al. 2012. Determining the
relative roles of species replacement and species richness
differences in generating beta-diversity patterns. - Global
Ecology and Biogeography 21: 760–771.

Podani, J. and Schmera, D. 2011. A new conceptual
and methodological framework for exploring and explaining
pattern in presence - absence data. - Oikos 120: 1625–1638.

Hidasi-Neto, J. et al. 2019. Climate change will
drive mammal species loss and biotic homogenization in the
Cerrado Biodiversity Hotspot. - Perspectives in Ecology and
Conservation 17: 57–63.
}
