% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{normalize.covariates2}
\alias{normalize.covariates2}
\title{Normalize the covariates of a data set to lie in the unit interval by
transforming based on PCA.}
\usage{
normalize.covariates2(
  data = NULL,
  x = NULL,
  idxs.c = "all",
  norm.cov.out = NULL,
  ...
)
}
\arguments{
\item{data}{(optional) Data set to be used to construct the normalizing
transformation. Default is \code{data = NULL}.}

\item{x}{(optional) Vector of covariates to be normalized alongside the data.
Default is \code{x = NULL}.}

\item{idxs.c}{(optional) Vector of indices of covariates that are continuous.
Note that that indices are relative to the covariate vector, not the full
data set. Default value is \code{idxs.c = "all"}, which indicates that all
elements should be regarded as continuous. If \code{idxs.c = NULL}, all
elements are regarded as discrete.}

\item{norm.cov.out}{(optional) The output of a previous call to this function.
Can be used to speed up computation. If both \code{data} and
\code{norm.cov.out} are supplied to the function, the function will throw an
error. Default is \code{norm.cov.out = NULL}}

\item{...}{Allows easier interchangeability between covariate normalization
functions. All arguments specified under \code{...} will be ignored.}
}
\description{
This function normalized the covariates in the data to lie in
the unit interval based on a principal component analysis. It is useful to
perform this step when defining the instrumental functions later on. This
function is used in \code{G.box}, \code{G.spline} and by extension \code{G.cd}.
}
