% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTransfoCompRisks.R
\name{LikI.cmprsk}
\alias{LikI.cmprsk}
\title{Second step log-likelihood function under independence assumption.}
\usage{
LikI.cmprsk(par, data, eoi.indicator.names, admin, conf, cf)
}
\arguments{
\item{par}{Vector of all second step model parameters, consisting of the
regression parameters, variance-covariance matrix elements and transformation
parameters.}

\item{data}{Data frame resulting from the 'uniformize.data.R' function.}

\item{eoi.indicator.names}{Vector of names of the censoring indicator columns
pertaining to events of interest. Events of interest will be modeled allowing
dependence between them, whereas all censoring events (corresponding to
indicator columns not listed in \code{eoi.indicator.names}) will be treated
as independent of every other event.}

\item{admin}{Boolean value indicating whether the data contains
administrative censoring.}

\item{conf}{Boolean value indicating whether the data contains confounding
and hence indicating the presence of Z and W}

\item{cf}{"Control function" to be used. This can either be the (i) estimated
control function, (ii) the true control function, (iii) the instrumental
variable, or (iv) nothing (\code{cf = NULL}). Option (ii) is used when
comparing the two-step estimator to the oracle estimator, and option (iii) is
used to compare the two-step estimator with the naive estimator.}
}
\value{
Log-likelihood evaluation for the second step in the esimation
procedure.
}
\description{
This function defines the log-likelihood used to estimate
the second step in the competing risks extension assuming independence of
some of the competing risks in the model described in Willems et al. (2024+).
}
\references{
Willems et al. (2024+). Flexible control function approach under competing risks (in preparation).
}
