% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{EAM.converged}
\alias{EAM.converged}
\title{Check convergence of the EAM algorithm.}
\usage{
EAM.converged(
  opt.val.prev,
  evaluations,
  mp.theta.next,
  iter.nbr,
  dir,
  hyperparams,
  verbose
)
}
\arguments{
\item{opt.val.prev}{Previous optimal theta value.}

\item{evaluations}{Matrix of violation curve evaluations.}

\item{mp.theta.next}{Most promising value of theta for which to run the
E-step in the following iteration}

\item{iter.nbr}{Number of iterations of the EAM algorithm run so far.}

\item{dir}{Search direction.}

\item{hyperparams}{List of hyperparameters used in the EAM algorithm.}

\item{verbose}{Verbosity parameter.}
}
\value{
Boolean value whether or not algorithm has converged.
}
\description{
This function checks the convergence of the EAM algorithm.
ToDo: Get rid of hard coding stop of algorithm when no more improvement of
theta values (maybe related to parameter space contraction, since the problem
is that the given points to check in the E-step of the following iteration
can always be the same and always be rejected (except of course for the
randomly chosen one), while the most promising theta value continues to be
the same, infeasible value. In this way, it is possible that
theta.hash - mp.theta.next at some point will never decrease).
}
