% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{Bspline.unit.interval}
\alias{Bspline.unit.interval}
\title{Evaluate the specified B-spline, defined on the unit interval}
\usage{
Bspline.unit.interval(x, spline.index, n.if.per.cov, degree = 3)
}
\arguments{
\item{x}{value inside the unit interval at which to evaluate the spline.}

\item{spline.index}{Index of the spline to evaluate.}

\item{n.if.per.cov}{Number of B-splines to consider over the unit interval.}

\item{degree}{Degree of the B-splines. Default is \code{degree = 3}.}
}
\description{
This function evaluates the specified B-spline defined on the
unit interval, when considering \code{n.if.per.cov} B-splines. Currently, the
implementation is based on the one in Andrews, Shi 2013 (supplementary
materials).
}
\references{
Andrews, D.W.K. and Shi, X. (2013). Inference based on
confitional moment inequalities. Econometrica. 81(2):609-666.
}
