% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepregression_torch.R
\name{torch_dr}
\alias{torch_dr}
\title{Compile a Deep Distributional Regression Model (Torch)}
\usage{
torch_dr(
  list_pred_param,
  optimizer = torch::optim_adam,
  model_fun = NULL,
  monitor_metrics = list(),
  from_preds_to_output = from_preds_to_dist_torch,
  loss = from_dist_to_loss_torch(family = list(...)$family, weights = NULL),
  additional_penalty = NULL,
  ...
)
}
\arguments{
\item{list_pred_param}{list of output(-lists) generated from
\code{subnetwork_init}}

\item{optimizer}{optimizer used. Per default Adam}

\item{model_fun}{NULL not needed for torch}

\item{monitor_metrics}{Further metrics to monitor}

\item{from_preds_to_output}{function taking the list_pred_param outputs
and transforms it into a single network output}

\item{loss}{the model's loss function; per default evaluated based on
the arguments \code{family} and \code{weights} using \code{from_dist_to_loss}}

\item{additional_penalty}{a penalty that is added to the negative log-likelihood;
must be a function of model$trainable_weights with suitable subsetting (not implemented for torch)}

\item{...}{arguments passed to \code{from_preds_to_output}}

\item{weights}{vector of positive values; optional (default = 1 for all observations)}
}
\value{
a luz_module_generator
}
\description{
Compile a Deep Distributional Regression Model (Torch)
}
