test_that("does function correctly transform date in ymd format to ISO", {
  test_data <- data.frame(a = c("2022-02-20T22:02:02","2022-02-02T22:02:02"),
                        b = c("2022/02/20 +0000:24:02GMT", "2022/02/02 +0000:24:02GMT"),
                        c = c("22FEB20 +0000:24:02GMT", "22FEB02 +0000:24:02GMT"),
                        d = c("2022-02-20", "2022/02/02"),
                        e = c("ab2022-02-20", "ab2022-02-02"),
                        f = c(NA, "2022/02/02"),
                        f1 = c("2022/02/20", NA),
                        g = c("", "2022/02/02"),
                        h = c("2022 02 20 :18:24 00000000", "2022 02 02 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab2022-02-20", "ab2022-02-02"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})


test_that("does function correctly transform date in ydm format to ISO", {
  test_data <- data.frame(a = c("2022-20-02T22:02:02", "2022-02-02T22:02:02"),
                        b = c("2022/20/02 +0000:24:02GMT", "2022/02/02 +0000:24:02GMT"),
                        c = c("2022/20/02 +0000:24:02GMT", "2022/02/02 +0000:24:02GMT"),
                        d = c("2022-20-02", "2022/02/02"),
                        e = c("ab2022-20-02", "ab2022-02-02"),
                        f = c(NA, "2022/02/02"),
                        f1 = c("2022/20/02", NA),
                        g = c("", "2022/02/02"),
                        h = c("2022 20 02 :18:24 00000000", "2022 02 02 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab2022-20-02", "ab2022-02-02"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})

test_that("does function correctly transform date in myd format to ISO", {
  test_data <- data.frame(a = c("02-2022-20T22:02:02", "02-2022-02T22:02:02"),
                        b = c("02/2022/20 +0000:24:02GMT", "02/2022/02 +0000:24:02GMT"),
                        c = c("FEB202022 +0000:24:02GMT", "FEB022022 +0000:24:02GMT"),
                        d = c("02-2022-20", "02/2022/02"),
                        e = c("ab02-2022-20", "ab02-2022-02"),
                        f = c(NA, "02/2022/02"),
                        f1 = c("20/2022/02", NA),
                        g = c("", "02/2022/02"),
                        h = c("02 2022 20 :18:24 00000000", "02 2022 02 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab02-2022-20", "ab02-2022-02"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})

test_that("does function correctly transform date in mdy format to ISO", {
  test_data <- data.frame(a = c("02-2022-20T22:02:02", "02-2022-02T22:02:02"),
                        b = c("02/2022/20 +0000:24:02GMT", "02/2022/02 +0000:24:02GMT"),
                        c = c("FEB202022 +0000:24:02GMT", "FEB022022 +0000:24:02GMT"),
                        d = c("02-2022-20", "02/2022/02"),
                        e = c("ab02-2022-20T", "ab02-2022-02oT"),
                        f = c(NA, "02/2022/02"),
                        f1 = c("02/2022/20", NA),
                        g = c("", "02/2022/02"),
                        h = c("02 2022 20 :18:24 00000000", "02 2022 02 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab02-2022-20", "ab02-2022-02"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})

test_that("does function correctly transform date in mdy format to ISO", {
  test_data <- data.frame(a = c("02-20-2022T22:02:02", "02-02-2022T22:02:02"),
                        b = c("02/20/2022 +0000:24:02GMT", "02/02/2022 +0000:24:02GMT"),
                        c = c("FEB/20/2022 +0000:24:02GMT", "FEB/02/2022 +0000:24:02GMT"),
                        d = c("02-20-2022", "02/02/2022"),
                        e = c("ab02-20-2022", "ab02-02-2022"),
                        f = c(NA, "02/02/2022"),
                        f1 = c("02/20/2022", NA),
                        g = c("", "02/02/2022"),
                        h = c("02 20 2022 :18:24 00000000", "02 02 2022 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab02-20-2022", "ab02-02-2022"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})


test_that("does function correctly transform date in dym format to ISO", {
  test_data <- data.frame( a = c("20-2022-02T22:02:02", "02-2022-02T22:02:02"),
                         b = c("20/2022/02 +0000:24:02GMT", "02/2022/02 +0000:24:02GMT"),
                         c = c("20/2022/Feb +0000:24:02GMT", "02/2022/FEB +0000:24:02GMT"),
                         d = c("20-2022-02", "02/2022/02"),
                         e = c("ab20-2022-02", "ab02-2022-02"),
                         f = c(NA, "02/2022/02"),
                         f1 = c("20/2022/02", NA),
                         g = c("", "02/2022/02"),
                         h = c("20 2022 02 :18:24 00000000", "02 2022 02 :18:24 00000000"))
  test_data <- dfiso(test_data)
  actual <- data.frame(a = c("2022-02-20", "2022-02-02"),
                     b = c("2022-02-20", "2022-02-02"),
                     c = c("2022-02-20", "2022-02-02"),
                     d = c("2022-02-20", "2022-02-02"),
                     e = c("ab20-2022-02", "ab02-2022-02"),
                     f = c(NA, "2022-02-02"),
                     f1 = c("2022-02-20", NA),
                     g = c("", "2022-02-02"),
                     h = c("2022-02-20", "2022-02-02"))
  expect_identical(actual, test_data)
})
