% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importNGWMN_wml2.R
\name{importWaterML2}
\alias{importWaterML2}
\title{Parse the WaterML2 timeseries portion of a waterML2 file}
\usage{
importWaterML2(input, asDateTime = FALSE, tz = "UTC")
}
\arguments{
\item{input}{XML with only the wml2:MeasurementTimeseries node and children}

\item{asDateTime}{logical, if \code{TRUE} returns date and time as POSIXct, if \code{FALSE}, character}

\item{tz}{character to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided time zone offset).
Possible values are "America/New_York", "America/Chicago", "America/Denver", "America/Los_Angeles",
"America/Anchorage", "America/Honolulu", "America/Jamaica", "America/Managua",
"America/Phoenix", and "America/Metlakatla"}
}
\description{
Returns data frame columns of all information with each time series measurement;
Anything defined as a default, is returned as an attribute of that data frame.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
baseURL <- httr2::request("https://waterservices.usgs.gov/nwis/dv")
baseURL <- httr2::req_url_query(baseURL,
                                format = "waterml,2.0",
                                sites = "01646500",
                                startDT = "2014-09-01",
                                endDT = "2014-09-08",
                                statCd = "00003",
                                parameterCd = "00060" )

timeseries <- importWaterML2(baseURL, asDateTime = TRUE, tz = "UTC")
}
\dontshow{\}) # examplesIf}
}
