% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_gtsummary_roche.R
\name{theme_gtsummary_roche}
\alias{theme_gtsummary_roche}
\title{Roche Theme}
\usage{
theme_gtsummary_roche(set_theme = TRUE, font_size = NULL)
}
\arguments{
\item{set_theme}{(scalar \code{logical})\cr
Logical indicating whether to set the theme. Default is \code{TRUE}.
When \code{FALSE} the named list of theme elements is returned invisibly}

\item{font_size}{(scalar \code{numeric})\cr
Numeric font size for compact theme.
Default is 13 for gt tables, and 8 for all other output types}
}
\value{
theme list
}
\description{
A gtsummary theme for Roche tables
\itemize{
\item Calls the \code{\link[gtsummary:theme_gtsummary]{gtsummary::theme_gtsummary_compact()}} theme.
\item Uses \code{label_roche_pvalue()} as the default formatting function for all p-values.
\item Defaults to a mono-spaced font for gt tables.
}
}
\examples{
theme_gtsummary_roche()

tbl_demographics(gtsummary::trial, by = trt, include = c(age, grade))

gtsummary::reset_gtsummary_theme()
}
