% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_symbol_aliases.R
\name{likely_symbol}
\alias{likely_symbol}
\title{Retrieve Symbol Aliases and Previous symbols to determine a likely current symbol}
\usage{
likely_symbol(
  syms,
  alias_sym = TRUE,
  prev_sym = TRUE,
  orgnsm = "human",
  hgnc = NULL,
  hgnc_url = NULL,
  output = c("likely", "symbols", "all"),
  verbose = TRUE
)
}
\arguments{
\item{syms}{(\code{character}). Vector of Gene Symbols to be tested.}

\item{alias_sym}{(\code{logical}). Should the input be assumed to be an Alias? Defaults to \code{TRUE}.}

\item{prev_sym}{(\code{logical}). Should the input be assumed to be a Previous Symbol? Defaults to \code{TRUE}.}

\item{orgnsm}{(\code{character}). The organism for which the Symbols are tested.}

\item{hgnc}{(\code{data.frame}). An optional data frame with the needed HGNC annotations. (Needs to match the format
available at \code{hgnc_utl}!)}

\item{hgnc_url}{(\code{character}). URL where to download the HGNC annotation dataset. Defaults to
\code{"https://storage.googleapis.com/public-download-files/hgnc/tsv/tsv/hgnc_complete_set.txt"}.}

\item{output}{(\code{character}). One of "likely", "symbols" and "all". Determines the scope of the output data frame.
Defaults to \code{"likely"} which will return the inout Symbol and the determined likely Symbol.}

\item{verbose}{(\code{logical}). Should messages be written to the console? Defaults to \code{TRUE}.}
}
\value{
A \code{data.frame} with the following columns depending on the \code{output} setting.
\strong{\code{output="likely"}}:
\tabular{ll}{
\tab 'likely_symbol'\cr
\tab 'input_symbol'\cr
}
\strong{\code{output="symbols"}}:
\tabular{ll}{
\tab 'current_symbols'\cr
\tab 'likely_symbol'\cr
\tab 'input_symbol'\cr
\tab 'all_symbols'\cr
}
\strong{\code{output="all"}}:
\tabular{ll}{
\tab 'orig_input'\cr
\tab 'organism'\cr
\tab 'current_symbols'\cr
\tab 'likely_symbol'\cr
\tab 'input_symbol'\cr
\tab 'all_symbols'\cr
}
}
\description{
\command{likely_symbol()} downloads the latest version of the HGNC gene symbol database as a text
    file and query it to obtain symbol aliases, previous symbols and all symbols currently in use. (Optionally)
    assuming the input ID to be either an Alias or a Symbol or a Previous Symbol it performs multiple queries and
    compares the results of all possible combinations to determine a likely current Symbol.
}
\details{
Please note that the algorithm is very slow for large input vectors.
}
\note{
Only fully implemented for Human for now.
}
\examples{
\dontrun{
likely_symbol(c("ABCC4", "ACPP", "KIAA1524"))
}
}
