% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concom.R
\name{concom}
\alias{concom}
\title{Connected components}
\usage{
concom(edges)
}
\arguments{
\item{edges}{a matrix with two columns, whose rows represent the edges of 
the graph; each edge is given by two vertex indices, and it is assumed 
that the vertex indices are 1, 2, 3, ...}
}
\value{
A list with four elements: \code{indices}, an integer vector 
  whose \code{i}-th element gives the label of the connected component of 
  vertex \code{i}; \code{sizes}, an integer vector giving the number of 
  elements of each connected component; \code{ncomponents}, the number 
  of connected components; \code{components}, a list of length 
  \code{ncomponents}, whose \code{j}-th element is the integer vector made 
  of the labels of the \code{j}-th connected component.
}
\description{
Fast computation of the connected components of an undirected 
  graph.
}
\examples{
library(concom)
edges <- cbind(
  1:7,
  c(2, 3, 1, 5, 6, 7, 4)
)
concom(edges)
}
