% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_getTargetRegions}
\alias{comparison_getTargetRegions}
\title{Extract regions from a target scan based on associated cells in reference scan}
\usage{
comparison_getTargetRegions(
  cellHeightValues,
  target,
  theta = 0,
  sideLengthMultiplier = 3,
  ...
)
}
\arguments{
\item{cellHeightValues}{list/tibble column of x3p objects containing a
reference scan's cells (as returned by comparison_cellDivision)}

\item{target}{x3p object containing a breech face scan to be compared to the
reference cell.}

\item{theta}{degrees that the target scan is to be rotated prior extracting
regions.}

\item{sideLengthMultiplier}{ratio between the target region and reference cell
side lengths. For example, sideLengthMultiplier = 3 implies each region will
be 9 times larger than its paired reference cell.}

\item{...}{internal usage}
}
\value{
A list of the same length as the input containing x3p objects from the
target scan.
}
\description{
Extract regions from a target scan based on associated cells in reference scan
}
\examples{

data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = c(8,8)) \%>\%
dplyr::mutate(regionHeightValues = comparison_getTargetRegions(cellHeightValues = cellHeightValues,
                                                               target = fadul1.2_processed)) \%>\%
dplyr::mutate(cellPropMissing = comparison_calcPropMissing(heightValues = cellHeightValues),
              regionPropMissing = comparison_calcPropMissing(heightValues = regionHeightValues)) \%>\%
dplyr::filter(cellPropMissing <= .85 & regionPropMissing <= .85)

head(cellTibble)

}
