% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.clmstan}
\alias{coef.clmstan}
\title{Extract coefficients from clmstan objects}
\usage{
\method{coef}{clmstan}(object, type = c("mean", "median"), ...)
}
\arguments{
\item{object}{A clmstan object}

\item{type}{Type of point estimate: "mean" (default) or "median"}

\item{...}{Additional arguments (ignored)}
}
\value{
A named numeric vector with:
\itemize{
\item Threshold coefficients (e.g., "1|2", "2|3", ...)
\item Regression coefficients (variable names from formula)
}
}
\description{
Returns posterior point estimates (mean or median) for all model parameters.
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
coef(fit)
coef(fit, type = "median")
}

}
