% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{reach}
\alias{reach}
\title{Perform the CIfly algorithm specified in the passed ruletable.}
\usage{
reach(graph, sets, ruletable, tableAsString = FALSE, verbose = FALSE)
}
\arguments{
\item{graph}{A list mapping edge types to edge lists stored in matrix format.}

\item{sets}{A list mapping set names to a list of elements.}

\item{ruletable}{Path to a ruletable file.}

\item{tableAsString}{Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.}

\item{verbose}{Optional argument to enable logging. Default value is FALSE.}
}
\value{
A vector of all reachable nodes.
}
\description{
For the given graph and sets, a CIfly reachability algorithm is run according to the ruletable specified in the ruletable argument. The algorithm returns all reachable nodes. It is guaranteed to run in linear-time.
}
\examples{
dsepTable <- "
    EDGES --> <--
    SETS X, Z
    START <-- AT X
    OUTPUT ...
    --> | <-- | current in Z
    ... | ... | current not in Z
"

edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))
sets <- list("X" = c(1), "Z" = c(4))
reach(edgelist, sets, dsepTable, tableAsString=TRUE)
}
