% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chronicle.R
\name{check_g}
\alias{check_g}
\title{Check the output of the .g function}
\usage{
check_g(.c, columns = c("ops_number", "function"))
}
\arguments{
\item{.c}{A chronicle object.}

\item{columns}{Columns to select for the output. Defaults to c("ops_number", "function").}
}
\value{
A data.frame with the selected columns and column "g".
}
\description{
Check the output of the .g function
}
\details{
`.g` is an option argument to the `record()` function. Providing this optional
function allows you, at each step of a pipeline, to monitor interesting characteristics
of the `value` object. See the package's Readme file for an example with data frames.
}
\examples{
r_subset <- record(subset, .g = dim)
result <- r_subset(mtcars, select = am)
check_g(result)
}
