% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview.R
\name{overview}
\alias{overview}
\alias{overview.default}
\alias{overview.logical}
\alias{overview.integer}
\alias{overview.numeric}
\alias{overview.integer64}
\alias{overview.character}
\alias{overview.factor}
\alias{overview.Date}
\alias{overview.POSIXt}
\alias{overview.ts}
\alias{overview.zoo}
\alias{overview.data.frame}
\title{An alternative to \code{summary()} inspired by the skimr package}
\usage{
overview(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{default}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{logical}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{integer}(x, digits = getOption("cheapr.digits", 2), hist = TRUE, ...)

\method{overview}{numeric}(x, digits = getOption("cheapr.digits", 2), hist = TRUE, ...)

\method{overview}{integer64}(x, digits = getOption("cheapr.digits", 2), hist = TRUE, ...)

\method{overview}{character}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{factor}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{Date}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{POSIXt}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{ts}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{zoo}(x, digits = getOption("cheapr.digits", 2), ...)

\method{overview}{data.frame}(x, digits = getOption("cheapr.digits", 2), hist = TRUE, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{digits}{How many decimal places should the summary statistics be
printed as? Default is 2.}

\item{...}{Further arguments passed onto methods. Currently unused.}

\item{hist}{Should in-line histograms be returned? Default is \code{FALSE}.}
}
\value{
An object of class "overview".
Under the hood this is just a list of data frames.
Key summary statistics are reported in each data frame.
}
\description{
A cheaper \code{summary()} function, designed for larger data.
}
\details{
No rounding of statistics is done except in printing which can be controlled
either through the \code{digits} argument in \code{overview()}, or by setting the
option \code{options(cheapr.digits)}. \cr
To access the underlying data, for example the numeric summary,
just use \verb{$numeric}, e.g. \code{overview(rnorm(30))$numeric}.
}
\examples{
library(cheapr)
overview(iris)

# With histograms
overview(airquality, hist = TRUE)

# Round to 0 decimal places
overview(airquality, digits = 0)

# We can set an option for all overviews
options(cheapr.digits = 1)
overview(rnorm(100))
options(cheapr.digits = 2) # The default

}
