% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/office_emissions.R
\name{office_emissions}
\alias{office_emissions}
\title{Office emissions}
\usage{
office_emissions(
  specify = FALSE,
  office_num = 1,
  WFH_num = 0,
  WFH_hours = 0,
  WFH_type = c("Office Equipment", "Heating"),
  water_supply = 0,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = 0,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = 0,
  heat_TD = TRUE,
  heat_WTT = TRUE
)
}
\arguments{
\item{specify}{logical. Whether an average should be used, or if the amount of energy used will be specified.}

\item{office_num}{If \code{specify = FALSE}, the number of individuals in the office.}

\item{WFH_num}{Number of people working from home.}

\item{WFH_hours}{Number of hours working from home (per individual).}

\item{WFH_type}{Whether to account for \code{"Office Equipment"} and/or \code{"Heating"}. Default is both.}

\item{water_supply}{Amount of water used in the office.}

\item{water_trt}{logical. Default \code{TRUE}. Whether to include emissions associated with water treatment for used water.}

\item{water_unit}{Unit for \code{water_supply} variable. Options are \code{"cubic metres"} or \code{"million litres"}.}

\item{electricity_kWh}{Electricity used in kWh.}

\item{electricity_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{electricity_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}

\item{heat_kWh}{heat and steam used in kWh.}

\item{heat_TD}{logical. Default \code{TRUE}. Whether to include emissions associated with grid losses.}

\item{heat_WTT}{logical. Default \code{TRUE}. Whether to include emissions associated with extracting, refining, and transporting fuels.}
}
\value{
Returns CO2e emissions in tonnes.
}
\description{
Office emissions
}
\examples{
# specify emissions in an office
office_emissions(specify = TRUE, electricity_kWh = 200,
                 heat_kWh = 100, water_supply = 100, water_trt = FALSE)

}
\references{
Descriptions from 2022 UK Government Report: https://www.gov.uk/government/publications/greenhouse-gas-reporting-conversion-factors-2022
}
