% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdyplFit.R
\name{confint.mdyplFit}
\alias{confint.mdyplFit}
\title{Method for computing confidence intervals for one or more
regression parameters in a \code{\link[=mdyplFit]{"mdyplFit"}} object}
\usage{
\method{confint}{mdyplFit}(object, parm, level = 0.95, hd_correction = FALSE, se_start, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{parm}{a specification of which parameters are to be given
    confidence intervals, either a vector of numbers or a vector of
    names.  If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{hd_correction}{if \code{FALSE} (default), then the summary
corresponding to standard asymptotics is computed. If \code{TRUE}
then the high-dimensionality corrections in Sterzinger &
Kosmidis (2024) are employed to updates estimates, estimated
standard errors, z-statistics. See Details.}

\item{se_start}{a vector of starting values for the state evolution
equations. See the \code{start} argument in \code{\link[=solve_se]{solve_se()}}.}

\item{...}{additional argument(s) for methods.}
}
\description{
Method for computing confidence intervals for one or more
regression parameters in a \code{\link[=mdyplFit]{"mdyplFit"}} object
}
\examples{

\dontrun{

set.seed(123)
n <- 2000
p <- 800
set.seed(123)
betas <- c(rnorm(p / 4, mean = 7, sd = 1), rep(0, 3 * p / 4))
X <- matrix(rnorm(n * p, 0, 1/sqrt(n)), nrow = n, ncol = p)
probs <- plogis(drop(X \%*\% betas))
y <- rbinom(n, 1, probs)
fit_mdypl <- glm(y ~ -1 + X, family = binomial(), method = "mdyplFit")

wald_ci <- confint(fit_mdypl)
adj_wald_ci <- confint(fit_mdypl, hd_correction = TRUE)
ag_coverage <- function(cis, beta) mean((cis[, 1] < beta) & (cis[, 2] > beta))
ag_coverage(wald_ci, betas)
ag_coverage(adj_wald_ci, betas)

}

}
\seealso{
\code{\link[=mdyplFit]{mdyplFit()}}, \code{\link[=summary.mdyplFit]{summary.mdyplFit()}}
}
\author{
Ioannis Kosmidis \verb{[aut, cre]} \email{ioannis.kosmidis@warwick.ac.uk}
}
