% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unload.r
\name{unload}
\alias{unload}
\alias{reload}
\alias{purge_cache}
\title{Unload or reload modules}
\usage{
\special{box::unload(mod)}

\special{box::reload(mod)}

\special{box::purge_cache()}
}
\arguments{
\item{mod}{a module object to be unloaded or reloaded}
}
\value{
These functions are called for their side effect. They do not return
anything.
}
\description{
Given a module which has been previously loaded and is assigned to an alias
\code{mod}, \code{box::unload(mod)} unloads it; \code{box::reload(mod)}
unloads and reloads it from its source. \code{box::purge_cache()} marks all
modules as unloaded.
}
\details{
Unloading a module causes it to be removed from the internal cache such that
the next subsequent \code{box::use} declaration will reload the module from
its source. \code{box::reload} unloads and reloads the specified modules and
all its transitive module dependencies. \code{box::reload} is \emph{not}
merely a shortcut for calling \code{box::unload} followed by \code{box::use},
because \code{box::unload} only unloads the specified module itself, not any
dependent modules.
}
\note{
Any other references to the loaded modules remain unchanged, and will
(usually) still work. Unloading and reloading modules is primarily useful for
testing during development, and \emph{should not be used in production code:}
in particular, unloading may break other module references if the
\code{.on_unload} hook unloaded any binary shared libraries which are still
referenced.

These functions come with a few restrictions.
\code{box::unload} attempts to detach names attached by the corresponding
\code{box::use} call.
\code{box::reload} attempts to re-attach these same names. This only works if
the corresponding \code{box::use} declaration is located in the same scope.
\code{box::purge_cache} only removes the internal cache of modules, it does
not actually invalidate any module references or names attached from loaded
modules.

\code{box::unload} will execute the \code{.on_unload} hook of the module, if
it exists.
\code{box::reload} will re-execute the \code{.on_load} hook of the module and
of all dependent modules during loading (after executing the corresponding
\code{.on_unload} hooks during unloading).
\code{box::purge_cache} will execute any existing \code{.on_unload} hooks in
all loaded modules.
}
\seealso{
\code{\link[=use]{box::use}}, \link[=mod-hooks]{module hooks}
}
