% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_model_info_extractor.R
\name{GOF_model_info_extractor}
\alias{GOF_model_info_extractor}
\title{R6 Class representing model information}
\description{
R6 does not offer interfaces. Hence all methods
are considered as abstract.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-yhat}{\code{GOF_model_info_extractor$yhat()}}
\item \href{#method-y_minus_yhat}{\code{GOF_model_info_extractor$y_minus_yhat()}}
\item \href{#method-beta_x_covariates}{\code{GOF_model_info_extractor$beta_x_covariates()}}
\item \href{#method-clone}{\code{GOF_model_info_extractor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-yhat"></a>}}
\if{latex}{\out{\hypertarget{method-yhat}{}}}
\subsection{Method \code{yhat()}}{
Abstract function that estimates/predicts the
  the dependent variable in \code{model}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_info_extractor$yhat(model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{fitted model}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
estimate/prediction of the dependent variable
  fitted by \code{model}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-y_minus_yhat"></a>}}
\if{latex}{\out{\hypertarget{method-y_minus_yhat}{}}}
\subsection{Method \code{y_minus_yhat()}}{
abstract function that calculates the residuals
  on the scale of the dependent variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_info_extractor$y_minus_yhat(model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{fitted model}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
residuals on the scale of the dependent variable
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-beta_x_covariates"></a>}}
\if{latex}{\out{\hypertarget{method-beta_x_covariates}{}}}
\subsection{Method \code{beta_x_covariates()}}{
abstract function that calculates the inner product
  of estimated parameters and the independent variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_info_extractor$beta_x_covariates(model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{fitted model}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
inner product of the estimated parameters and the
  independent variables.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GOF_model_info_extractor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
