% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emix.R
\name{emix}
\alias{emix}
\title{Compute expectations via weighted mixtures}
\usage{
emix(h, params, wts, ncores = 1, errorNodesWts = NULL, ...)
}
\arguments{
\item{h}{Function for which the expectation should be taken.  The function 
should be defined so it is can be called via \code{f(params, ...)}.
Additional parameters may be passed to \eqn{h} via \code{...}.}

\item{params}{Matrix in which each row contains parameters at which
\eqn{h} should be evaluated.  The number of rows in \code{params} should 
match the number of mixture components \eqn{k}.}

\item{wts}{vector of weights for each mixture component}

\item{ncores}{number of cores over which to evaluate mixture.  this function
assumes a parallel backend is already registered.}

\item{errorNodesWts}{list with elements \code{inds} and \code{weights} that 
point out which \code{params} get used to compute an approximation of the 
quadrature error.}

\item{...}{additional arguments to be passed to \code{h}}
}
\description{
Approximates expectations of the form
\deqn{E[h(\theta)] = \int h(\theta) f(\theta) d\theta}
using a weighted mixture
\deqn{E[h(\theta)] \approx \sum_{j=1}^k h(\theta^{(k)}) w_k}
}
\examples{
# density will be a mixture of betas
params = matrix(exp(2*runif(10)), ncol=2)

# mixture components are equally weighted
wts = rep(1/nrow(params), nrow(params))

# compute mean of distribution by cycling over each mixture component
h = function(p) { p[1] / sum(p) }

# compute mixture mean
mean.mix = emix(h, params, wts)

# (comparison) Monte Carlo estimate of mixture mean
nsamples = 1e4
component = sample(x = 1:length(wts), size = nsamples, prob = wts, 
                   replace = TRUE)
x = sapply(component, function(cmp) {
  rbeta(n = 1, shape1 = params[cmp, 1], shape2 = params[cmp, 2])
})
mean.mix.mc = mean(x)

# compare estimates
c(emix = mean.mix, MC = mean.mix.mc)
}
