% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outliers}
\alias{outliers}
\title{Descriptive and Visual Outlier Assessment}
\usage{
outliers(data, x, threshold = 1.5, color = "#79E1BE")
}
\arguments{
\item{data}{Dataframe containing the variables to be analyzed.}

\item{x}{Character string indicating the variable to be analyzed.}

\item{threshold}{Numeric value multiplying the IQR to define outlier boundaries. Default: 1.5.}

\item{color}{Character string indicating the color for non-outlier data points. Default: "#79E1BE".}
}
\value{
An object of class "outliers" containing a list with outlier statistics and ggplot objects.
}
\description{
Identifies outliers using Tukey's interquartile range (IQR) method and provides
descriptive statistics and visualizations for outlier assessment in numeric data.
}
\examples{
# Simulated clinical data
clinical_df <- clinical_data()

# Basic outlier detection
outliers(clinical_df, "biomarker")

# Using custom threshold
outliers(clinical_df, "biomarker", threshold = 1.0)

}
