% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-daylengths.R
\name{create_daylength_rst}
\alias{create_daylength_rst}
\title{Create day length rasters}
\usage{
create_daylength_rst(
  template,
  dates = terra::time(template),
  crs = "EPSG:4258",
  .quiet = FALSE
)
}
\arguments{
\item{template}{(Multi-layer) SpatRaster that determines the
spatial extent of the result.}

\item{dates}{Dates that should be processed. If not specified, the dates of
\code{template} are used through \code{\link[terra:time]{terra::time()}}.}

\item{crs}{Coordinate reference system with longitude/latitude metrics.
It is used to project the raster coordinates to be able to retrieve the
latitude.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
A multi-layer SpatRaster. Each layer represents one date.
}
\description{
Generate a multi-layer SpatRaster of day lengths for a given template.
The package \code{geosphere} is required to use this function.
}
\examples{
\dontshow{if (rlang::is_installed("geosphere")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# calculate day length, use barrks_data()$tmin as template
dl <- create_daylength_rst(barrks_data()$tmin, .quiet = TRUE)

# plot day length on May 1st, 2015
terra::plot(dl[[terra::time(dl) == '2015-05-01']])
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=create_daylength_df]{create_daylength_df()}}
}
