% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_put}
\alias{am_put}
\title{Put a value into an Automerge map or list}
\usage{
am_put(doc, obj, key, value)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID (from nested object), or \code{AM_ROOT}
for the document root}

\item{key}{For maps: character string key. For lists: numeric index
(1-based) or \code{"end"} to append}

\item{value}{The value to store. Supported types:
\itemize{
\item \code{NULL} - stores null
\item Logical - stores boolean (must be scalar)
\item Integer - stores integer (must be scalar)
\item Numeric - stores double (must be scalar)
\item Character - stores string (must be scalar)
\item Raw - stores bytes
\item \code{AM_OBJ_TYPE_LIST/MAP/TEXT} - creates nested object
}}
}
\value{
The document \code{doc} (invisibly).
}
\description{
Inserts or updates a value in an Automerge map or list. The function
automatically dispatches to the appropriate operation based on the object
type and key/position type.
}
\examples{
doc <- am_create()

# Put values in root map (returns doc invisibly)
am_put(doc, AM_ROOT, "name", "Alice")
am_put(doc, AM_ROOT, "age", 30L)
am_put(doc, AM_ROOT, "active", TRUE)

# Create nested list and retrieve it
am_put(doc, AM_ROOT, "items", AM_OBJ_TYPE_LIST)
items <- am_get(doc, AM_ROOT, "items")
}
