% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aicTable.R
\name{aicTable}
\alias{aicTable}
\title{ARIMA AIC table}
\usage{
aicTable(data, P, Q, D = 0, ic = c("aic", "aicc"), ...)
}
\arguments{
\item{data}{a time series object, or a dataset that can be used as input into
the \link{arima} function.}

\item{P}{a positive integer value representing the maximum number of AR
coefficients that should be included in the table.}

\item{Q}{a positive integer value representing the maximum number of MA
coefficients that should be included in the table.}

\item{D}{a positive integer value representing the degree of differencing}

\item{ic}{Information criterion to be used in the table.}

\item{...}{Additional arguments passed to \code{\link[=arima]{arima()}}.}
}
\value{
A matrix containing the model AIC values.
}
\description{
Construct table of AIC for all combinations 0<=p<=P and 0<=q<=Q
}
\details{
This function creates an AIC table for ARMA models of varying sizes.
Each row for the table corresponds to a different AR value, and each column
of the table corresponds to a different MA value.
}
\examples{
set.seed(654321)
aicTable(presidents, 3, 2)
}
