% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProfileDendrogram.R
\name{plotProfileDendrogram}
\alias{plotProfileDendrogram}
\title{Plot soil profiles below a dendrogram}
\usage{
plotProfileDendrogram(
  x,
  clust,
  rotateToProfileID = FALSE,
  scaling.factor = 0.01,
  width = 0.1,
  y.offset = 0.1,
  dend.y.scale = max(clust$height * 2, na.rm = TRUE),
  dend.color = par("fg"),
  dend.width = 1,
  dend.type = c("phylogram", "cladogram"),
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{clust}{a hierarchical clustering object generated by \code{hclust}, \code{cluster::agnes}, or \code{cluster::diana}}

\item{rotateToProfileID}{logical, attempt rotation of dendrogram according to original profile IDs, requires \code{dendextend} package}

\item{scaling.factor}{vertical scaling of the profile heights (may have to tinker with this)}

\item{width}{scaling of profile widths}

\item{y.offset}{vertical offset for top of profiles}

\item{dend.y.scale}{extent of y-axis (may have to tinker with this)}

\item{dend.color}{dendrogram line color}

\item{dend.width}{dendrogram line width}

\item{dend.type}{dendrogram type, passed to \code{plot.phylo()}, either "phylogram" or "cladogram"}

\item{debug}{logical, optionally print debugging data and return a \code{data.frame} of linking structure}

\item{...}{additional arguments to \code{plotSPC}}
}
\value{
This function is typically called to create graphical output, when \code{debug=TRUE} a \code{data.frame} of IDs and linking structure used to build the figure.
}
\description{
Plot soil profiles below a dendrogram, using methods from the ape package.
}
\note{
You may have to tinker with some of the arguments to get optimal arrangement and scaling of soil profiles.
}
\author{
D.E. Beaudette
}
\keyword{hplots}
