% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareSites.R
\name{compareSites}
\alias{compareSites}
\title{Compare Site Level Attributes of a SoilProfileCollection}
\usage{
compareSites(x, vars, weights = rep(1, times = length(vars)), ...)
}
\arguments{
\item{x}{\code{SoilProfileCollection} object}

\item{vars}{character vector listing one or more site level attributes of \code{x}}

\item{weights}{numeric vector, same length as \code{vars}, variable weighting}

\item{...}{additional arguments to \code{\link[cluster:daisy]{cluster::daisy()}}}
}
\value{
\code{dissimilarity} / \code{dist} class object containing pair-wise distances, row/column names derived from \code{profile_id(x)}
}
\description{
Compare site level attributes of a \code{SoilProfileCollection} object, returning a distance matrix conformal with the output from \code{\link[=NCSP]{NCSP()}}. Values are within the range of 0-1.
}
\details{
This function is typically used in conjunction with the output from \code{\link[=NCSP]{NCSP()}}.
}
\seealso{
\code{\link[=NCSP]{NCSP()}} \code{\link[cluster:daisy]{cluster::daisy()}}
}
