% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPeaks.R
\name{plotPeaks}
\alias{plotPeaks}
\title{plotPeaks}
\usage{
plotPeaks(peaksWN, data_abs, data_ndd, fontFamily = NULL)
}
\arguments{
\item{peaksWN}{A vector with the peaks wave numbers.}

\item{data_abs}{A data frame, which contains in the first column the wave
numbers and in the following columns the samples absorbances.}

\item{data_ndd}{A data frame, which contains in the first column the wave
numbers and in the following columns the samples second derivative values.}

\item{fontFamily}{The desired graphic font family.}
}
\description{
This function makes a graphic representation of the peaks over
  the second derivative and/or absorbance sum spectra.
}
\examples{
# Plot the peaks found by findPeaks()
# 1. Based on absorbance sum spectrum
fp.abs <- findPeaks(andurinhaData, ndd = FALSE)
plotPeaks(fp.abs[[3]]$WN, fp.abs$dataZ)

# 2. Based on second derivative spectrum
fp.ndd <- findPeaks(andurinhaData, cutOff = 0.25)
plotPeaks(fp.ndd[[4]]$WN, fp.ndd$dataZ, fp.ndd$secondDerivative)

}
\seealso{
\code{\link{importSpectra}}, \code{\link{findPeaks}} and
  \code{\link{gOverview}}
}
