% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roclet_rdx.R
\name{capture_output}
\alias{capture_output}
\title{Capture Output and Messages}
\usage{
capture_output(expr, srcref = NULL, expected_cnds = NULL, env = caller_env())
}
\arguments{
\item{expr}{An R expression to evaluate

\describe{
\item{Permitted values}{An unquoted R expression}
\item{Default value}{none}
}}

\item{srcref}{The source reference of the expression

\describe{
\item{Default value}{\code{NULL}}
}}

\item{expected_cnds}{A character vector of expected conditions

If the expression issues a condition of a class that is in this vector, the
condition is ignored but added to the return value.

Otherwise, an error is issued.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{env}{The environment in which to evaluate the expression

\describe{
\item{Default value}{\code{caller_env()}}
}}
}
\value{
A character vector of captured output and messages
}
\description{
The function captures both output and expected messages from an R expression.
If the expression results in an unexpected message, an error is issued.
}
\keyword{documentation}
\section{Examples}{
\subsection{Capture Output and Messages}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{capture_output(1 + 1)
#> [1] "[1] 2"

capture_output(log(-1))
#> Error in capture_output(log(-1)) : The expression
#> > log(-1)
#> issued an unexpected condition:
#> NaNs produced
#> If this is expected, add any of the classes "simpleWarning", "warning", and
#> "condition" to the argument `expected_cnds`.

capture_output(log(-1), expected_cnds = "warning")
#> [1] "[1] NaN"                            "Warning in log(-1) : NaNs produced"}\if{html}{\out{</div>}}}}

