# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'Returns the desireability value of a dose.
#'
#'Takes estimated posterior mean efficacy and toxicity values and returns the posterior mean desireability score for a given tradeoff contour.
#'@param PE True or estimated probability of efficacy.
#'@param PT True of estimated probability of toxicity.
#'@param Contour Vector containing 4 entries used to make the desireability function. Contour(1) contains a desired toxicity probability given efficacy, Countour(2) contains a desired efficacy probability given toxicity, and (Contour(3),Contour(4)) is an equally desireable pair of efficacy and toxicity probabilities that are non zero or one.
#'@useDynLib UtilityFrailtyPH12
#'@importFrom Rcpp evalCpp
#'@examples
#'PE=.6
#'PT=.2
#'##Contour values
#'Contour=c(.35,.7,.8,.6)
#'GetDesire(PE,PT,Contour)
#'@export
GetDesire <- function(PE, PT, Contour) {
    .Call('_UtilityFrailtyPH12_GetDesire', PACKAGE = 'UtilityFrailtyPH12', PE, PT, Contour)
}

#' Samples from the posterior of the utility based phase12 model.
#' 
#' Takes arguments of data, hypermens and hypervariance vectors and returns a list of posterior samples from the Utility based phase12 model decribed by Chapple and Thall (2019).
#'
#'@param YE Binary indicator vector of efficacy status.
#'@param YT Binary indicator vector of toxicity status.
#'@param Doses Vector of integer Doses given to patients.
#'@param HypermeansEFF Vector of length nDose for dose prior means for efficacy.
#'@param HypermeansTOX Vector of length nDose for dose prior means for toxicity
#'@param Hypervars Length 5 vector of hypervariances. Hypervars(1) and Hypervars(2) contains the Latent parameter variance for normal probability of efficacy and toxicity. Hypervars(3) and Hypervars(4) contains the hypervariance on dose specific mean efficacy and toxicity parameters and Hypervars(5) contains the frailty variance parameter.
#'@param B Number of iterations to run for the MCMC.
#'@return A list of posterior samples after burnin in order: Posterior efficacy dose-vector, Posterior toxicity dose-vector, Posterior correlation.
#'@examples
#'n=100  #Generate Data
#'YE=rbinom(n,1,.6)
#'YT=rbinom(n,1,.2)
#'nDose=5
#'Doses=sample(1:nDose,n,replace=TRUE)
#'##Hyperparameters 
#'HypermeansEFF=c(-1,-.5,0,.5,1,2)
#'HypermeansTOX=HypermeansEFF
#'Hypervars=c(1,1,36,36,1)
#'B=100
#'UTEFFTOX(YE, YT,Doses,HypermeansEFF,HypermeansTOX, Hypervars, B)
#'@export
UTEFFTOX <- function(YE, YT, Doses, HypermeansEFF, HypermeansTOX, Hypervars, B) {
    .Call('_UtilityFrailtyPH12_UTEFFTOX', PACKAGE = 'UtilityFrailtyPH12', YE, YT, Doses, HypermeansEFF, HypermeansTOX, Hypervars, B)
}

