% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_clustering.R
\name{SpectralEigens}
\alias{SpectralEigens}
\alias{SpectralClustering}
\title{Eigenvalues for spectral clustering}
\usage{
SpectralEigens(D, nn = 10L, nEig = 2L)

SpectralClustering(D, nn = 10L, nEig = 2L)
}
\arguments{
\item{D}{Square matrix or \code{dist} object containing Euclidean distances
between data points.}

\item{nn}{Integer specifying number of nearest neighbours to consider}

\item{nEig}{Integer specifying number of eigenvectors to retain.}
}
\value{
\code{SpectralEigens()} returns spectral eigenvalues that can then be
clustered using a method of choice.
}
\description{
Spectral clustering emphasizes nearest neighbours when forming clusters;
it avoids some of the issues that arise from clustering around means /
medoids.
}
\examples{
library("TreeTools", quietly = TRUE)
trees <- as.phylo(0:18, nTip = 8)
distances <- ClusteringInfoDistance(trees)
eigens <- SpectralEigens(distances)
# Perform clustering:
clusts <- KMeansPP(dist(eigens), k = 3)
plot(eigens, pch = 15, col = clusts$cluster)
plot(cmdscale(distances), pch = 15, col = clusts$cluster)
}
\seealso{
Other tree space functions: 
\code{\link{Islands}()},
\code{\link{MSTSegments}()},
\code{\link{MapTrees}()},
\code{\link{MappingQuality}()},
\code{\link{cluster-statistics}},
\code{\link{median.multiPhylo}()}
}
\author{
Adapted by MRS from script by \href{https://rpubs.com/nurakawa/spectral-clustering}{Nura Kawa}
}
\concept{tree space functions}
