% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiWaveAnalisysParallel.R
\name{extractSubset}
\alias{extractSubset}
\title{Extract observations from a MultiWaveAnalysis}
\usage{
extractSubset(MWA, indices)
}
\arguments{
\item{MWA}{MultiWaveAnalysis from which the desired observations will be extracted}

\item{indices}{Indices that will indicate which observations will be
extracted}
}
\value{
A list with two elements:
\itemize{
\item MWA: The MultiWaveAnalysis provided minus the extracted observations.
\item MWAExtracted: A new MultiWaveAnalysis with the extracted observations
}
}
\description{
This function permits to extract certain observations from a MultiWaveAnalysis
}
\examples{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "haar", features = "Var")
aux <- extractSubset(MWA, c(1, 2, 3))
MWATrain <- aux[[1]]
MWATest <- aux[[2]]
}
