% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC2_TFM.R
\name{PPC2_TFM}
\alias{PPC2_TFM}
\title{Apply the PPC method to the Truncated factor model}
\usage{
PPC2_TFM(data, m, A, D)
}
\arguments{
\item{data}{The total data set to be analyzed.}

\item{m}{The number of principal components.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}
}
\value{
A list containing:
\item{Ap2}{Estimated factor loadings.}
\item{Dp2}{Estimated uniquenesses.}
\item{MSESigmaA}{Mean squared error for factor loadings.}
\item{MSESigmaD}{Mean squared error for uniquenesses.}
\item{LSigmaA}{Loss metric for factor loadings.}
\item{LSigmaD}{Loss metric for uniquenesses.}
}
\description{
This function performs Projected Principal Component Analysis (PPC) on a given data set to reduce dimensionality. It calculates the estimated values for the loadings, specific variances, and the covariance matrix.
}
\examples{
\dontrun{
library(SOPC)
library(relliptical)
library(MASS)
results <- PPC2_TFM(data, m, A, D)
print(results)
}
}
