% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgaretriever_v_1_9e.R
\name{cb_query}
\alias{cb_query}
\title{Core Query Engine}
\usage{
cb_query(my_url, body = NULL)
}
\arguments{
\item{my_url}{String. The URL pointing to the cBioPortal API.}

\item{body}{String. Parameters to be passed via POST to the query URL. Can be NULL.}
}
\value{
Data.frame including data retrieved from cBioPortal.
}
\description{
Submit a query by getting or posting to the URL provided as argument 
(typically a cbioportal.org URL). The function attempts the same query recursively
until the content has been completely downloaded. 
If `body` is NULL, the query is submitted via GET. Otherwise, 
the query is submitted via POST.
}
\details{
This is a core function invoked by other functions in the package.
}
\examples{
# The example below requires an active Internet connection.
\dontrun{
my_url <- "https://www.cbioportal.org/api/studies"
x <- TCGAretriever:::cb_query(my_url)
}
 
}
\references{
\url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
