% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimCheck.R
\name{SimCheck}
\alias{SimCheck}
\title{Check for missing files in array simulations}
\usage{
SimCheck(dir = NULL, files = NULL, min = 1L, max = NULL)
}
\arguments{
\item{dir}{character vector input indicating the directory
containing the \code{.rds} files (see \code{files})}

\item{files}{vector of file names referring to the saved simulation files.
E.g. \code{c('mysim-1.rds', 'mysim-2.rds', ...)}}

\item{min}{minimum number after the \code{'-'} deliminator. Default is 1}

\item{max}{maximum number after the \code{'-'} deliminator. If not specified
is extracted from the attributes in the first file}
}
\value{
returns an invisible list of indices of empty, missing and
  empty-and-missing row conditions. If no missing then an empty list is
  returned
}
\description{
Given the saved files from a \code{\link{runArraySimulation}} remote
evaluation check whether all \code{.rds} files have been saved. If missing
the missing row condition numbers will be returned.
}
\examples{
\dontrun{

# if files are in mysimfiles/ directory
SimCheck('mysimfiles')

# specifying files explicility
setwd('mysimfiles/')
SimCheck(files=dir())

}

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}
}
\seealso{
\code{\link{runArraySimulation}}, \code{\link{SimCollect}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
