% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo_multiomics_analysis.R
\name{demo_multiomics_analysis}
\alias{demo_multiomics_analysis}
\title{Demonstration of SUMO Utility in Multi-Omics Analysis using MOFA2}
\usage{
demo_multiomics_analysis(
  data_type = c("SUMO", "real_world"),
  export_pptx = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data_type}{Character. Options are \code{"SUMO"} for synthetic data or \code{"real_world"} for the CLL dataset.}

\item{export_pptx}{Logical. If \code{TRUE}, saves a PowerPoint summary of the analysis. Default is \code{TRUE}.}

\item{verbose}{Logical. If \code{TRUE}, prints progress messages. Default is \code{TRUE}.}
}
\value{
Invisibly returns the trained MOFA model object.
}
\description{
Run a complete MOFA2-based analysis pipeline using either SUMO-generated or real-world CLL multi-omics data.
This function includes preprocessing, MOFA model training, variance decomposition visualization, and optional PowerPoint report generation.
}
\details{
PowerPoint generation is skipped if required packages (\code{officer}, \code{rvg}, and \verb{systemfonts >= 1.1.0}) are not available.
}
\examples{
if (
  requireNamespace("MOFA2", quietly = TRUE) &&
  requireNamespace("MOFAdata", quietly = TRUE) &&
  requireNamespace("systemfonts", quietly = TRUE) &&
  utils::packageVersion("systemfonts") >= "1.1.0" &&
  identical(Sys.getenv("NOT_CRAN"), "true")
) {
  demo_multiomics_analysis("SUMO", export_pptx = FALSE)
  demo_multiomics_analysis("real_world", export_pptx = FALSE)
}

}
\seealso{
\code{\link[=simulate_twoOmicsData]{simulate_twoOmicsData()}}, \code{\link[=plot_factor]{plot_factor()}}, \code{\link[=plot_weights]{plot_weights()}}
}
\keyword{MOFA}
\keyword{demo}
\keyword{multi-omics}
\keyword{synthetic-data}
