% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs_snp.R
\name{knockoffGenotypes}
\alias{knockoffGenotypes}
\title{Group-knockoffs of unphased genotypes}
\usage{
knockoffGenotypes(X, r, alpha, theta, groups = NULL, seed = 123,
  cluster = NULL, display_progress = FALSE)
}
\arguments{
\item{X}{a {0,1,2} matrix of size n-by-p containing the original variables.}

\item{r}{a vector of length p containing the "r" parameters estimated by fastPHASE.}

\item{alpha}{a matrix of size p-by-K containing the "alpha" parameters estimated by fastPHASE.}

\item{theta}{a matrix of size p-by-K containing the "theta" parameters estimated by fastPHASE.}

\item{groups}{a vector of length p containing group memberships for each variable. Indices
are assumed to be monotone increasing, starting from 1 (default: NULL).}

\item{seed}{an integer random seed (default: 123).}

\item{cluster}{a computing cluster object created by \link[parallel]{makeCluster} (default: NULL).}

\item{display_progress}{whether to show progress bar (default: FALSE).}
}
\value{
A {0,1,2} matrix of size n-by-p containing the knockoff variables.
}
\description{
This function efficiently constructs group-knockoffs of {0,1,2} variables distributed
according to the Li and Stephens model for unphased genotypes.
}
\details{
Generate group-knockoffs of unphased genotypes according to the Li and Stephens HMM.
The required model parameters can be obtained through fastPHASE and loaded with \link{loadHMM}.
This function is more efficient than \link{knockoffHMM} for haplotype data.
}
\examples{
# Problem size
p = 10
n = 100
# Load HMM to generate data
r_file = system.file("extdata", "haplotypes_rhat.txt", package = "SNPknock")
alpha_file = system.file("extdata", "haplotypes_alphahat.txt", package = "SNPknock")
theta_file = system.file("extdata", "haplotypes_thetahat.txt", package = "SNPknock")
char_file = system.file("extdata", "haplotypes_origchars", package = "SNPknock")
hmm.data = loadHMM(r_file, alpha_file, theta_file, char_file, compact=FALSE, phased=FALSE)
hmm.data$Q = hmm.data$Q[1:(p-1),,]
hmm.data$pEmit = hmm.data$pEmit[1:p,,]
# Sample X from this HMM
X = sampleHMM(hmm.data$pInit, hmm.data$Q, hmm.data$pEmit, n=n)
# Load HMM to generate knockoffs
hmm = loadHMM(r_file, alpha_file, theta_file, char_file)
hmm$r = hmm$r[1:p]
hmm$alpha = hmm$alpha[1:p,]
hmm$theta = hmm$theta[1:p,]
# Generate knockoffs
Xk = knockoffGenotypes(X, hmm$r, hmm$alpha, hmm$theta)
# Generate group-knockoffs for groups of size 3
groups = rep(seq(p), each=3, length.out=p)
Xk = knockoffGenotypes(X, hmm$r, hmm$alpha, hmm$theta, groups=groups)
}
\references{
\insertRef{sesia2019multi}{SNPknock}
}
\seealso{
Other knockoffs: \code{\link{knockoffDMC}},
  \code{\link{knockoffHMM}},
  \code{\link{knockoffHaplotypes}}
}
\concept{knockoffs}
