% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.R
\name{sampler.gibbs}
\alias{sampler.gibbs}
\title{Gibbs sampling for node assignments}
\usage{
sampler.gibbs(currsbm, edges, sbmmod, sigma)
}
\arguments{
\item{currsbm}{the current state of the sampler}

\item{edges}{an \code{\link{edges}} object}

\item{sbmmod}{an \code{\link{sbmmod}} model}

\item{sigma}{random walk parameter for theta}
}
\value{
next state of \code{currsbm} object
}
\description{
Gibbs sampling for node assignments
}
\note{
This requires a block model with a fixed kappa
}
\examples{
model <- sbmmod(multinom(1, 3), param_gamma(1,1,1,1), edges_pois())
trueSBM <- model$r(10)
Edges <- redges(trueSBM, model$edge)
gibbs_out <- sampler(Edges, model, algorithm="gibbs", 10, sigma=0.1)
eval_plots(gibbs_out)
}
