# new_S3_class has a print method

    Code
      new_S3_class(c("ordered", "factor"))
    Output
      <S7_S3_class>: S3<ordered/factor>

# subclasses inherit validator

    Code
      foo2("a")
    Condition
      Error:
      ! <foo2> object is invalid:
      - Underlying data must be a double

# new_S3_class() checks its inputs

    Code
      new_S3_class(1)
    Condition
      Error:
      ! `class` must be a character vector

---

    Code
      new_S3_class("foo", function(x) { })
    Condition
      Error:
      ! First argument to `constructor` must be .data
    Code
      new_S3_class("foo", function(.data, ...) { })
    Condition
      Error:
      ! `constructor` can not use `...`

# default new_S3_class constructor errors

    Code
      class_construct(new_S3_class("foo"), 1)
    Condition
      Error:
      ! S3 class <foo> doesn't have a constructor

# catches invalid factors

    Code
      validate_factor(structure("x"))
    Output
      [1] "Underlying data must be an <integer>"   
      [2] "attr(, 'levels') must be a <character>" 
      [3] "Not enough 'levels' for underlying data"

# catches invalid dates

    Code
      validate_date("x")
    Output
      [1] "Underlying data must be numeric"       
      [2] "Underlying data must have class 'Date'"

# catches invalid POSIXct

    Code
      validate_POSIXct(structure("x", tz = "UTC"))
    Output
      [1] "Underlying data must be numeric"
    Code
      validate_POSIXct(structure(1, tz = 1))
    Output
      [1] "attr(, 'tz') must be a single string"

# catches invalid data.frame

    Code
      validate_data.frame(1)
    Output
      [1] "Underlying data must be a <list>"
    Code
      validate_data.frame(structure(list(x = 1, y = 1:2), row.names = 1L))
    Output
      [1] "All columns and row names must have the same length"
    Code
      validate_data.frame(structure(list(x = 1, y = 1), row.names = 1:2))
    Output
      [1] "All columns and row names must have the same length"
    Code
      validate_data.frame(structure(list(1), row.names = 1L))
    Output
      [1] "Underlying data must be named"

