% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_results.R
\name{export_results}
\alias{export_results}
\title{Export experiment results to a dataframe or file.}
\usage{
export_results(experiment, strategies = NULL, tracks = "all", file = NULL)
}
\arguments{
\item{experiment}{An \code{rtrack_experiment} object from
\code{\link{read_experiment}}.}

\item{strategies}{An optional \code{rtrack_strategies} object generated by
\code{\link{call_strategy}}. If present, the strategies corresponding to
the tracks in the experiment (after subsetting using the \code{tracks}
parameter) will be extracted and returned in the results.}

\item{tracks}{Which tracks should be exported. Default, "all", exports the
entire experiment object. A subset of tracks can be specified using either
numeric indices or a vector of track IDs following usual R standards.}

\item{file}{The file to which the results will be written. If \code{NULL}
(the default), the data will be returned as a
\code{\link[base]{data.frame}}.}
}
\value{
A \code{data.frame} containing the experimental groups and factors
  (as supplied in the original experiment description) together with the
  summary metrics. This is returned invisibly if \code{file} is specified.
}
\description{
Binds experiment data together with analysis results and optionally writes
this to file.
}
\details{
If only the results matching a thresholded subset of strategies should be
exported, then this can be achieved by performing strategy calling and
thresholding separately and passing the \code{strategies$tracks} component of
the resulting \code{rtrack_strategies} object to this function as the
parameter \code{tracks}. This will restrict the output of
\code{export_results} to only the tracks where an above-threshold strategy
has been determined.

If the parameter \code{file} is supplied, the file extension will be used to
determine which format to save the file in. The formats ".csv", ".csv2" (see
\code{\link[utils]{write.table}} for details of the formats), ".tsv" (
tab-delimited text; can also  be written as ".txt" or ".tab") and ".xlsx" are
supported. If the file extension is not in this list, the data will be
written as tab-delimited text with a warning. Note that the Excel ".xlsx"
format is supported, but the older ".xls" is not.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment <- read_experiment(experiment.description, format = "excel",
  project.dir = system.file("extdata", "", package = "Rtrack"))
# The code below returns a data.frame.
# Use the parameter 'file' to write to a file instead.
export_results(experiment)

}
\seealso{
\code{\link{call_strategy}}, \code{\link{threshold_strategies}}.
}
