% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{qqplot.rga}
\alias{qqplot.rga}
\title{Q-Q Plot for RGA Objects}
\usage{
qqplot.rga(x, main = "Q-Q Plot", ...)
}
\arguments{
\item{x}{An object of class \code{rga}.}

\item{main}{Title of the plot.}

\item{...}{Additional arguments passed to \code{stats::qqplot()}.}
}
\value{
A Q-Q plot comparing empirical and theoretical quantiles.
}
\description{
This function creates a Q-Q plot for a fitted Reliability Growth Analysis (RGA) model
Currently only supports the Crow-AMSAA model.
}
\examples{
times <- c(5, 10, 15, 20, 25)
failures <- c(1, 2, 1, 3, 2)
fit <- rga(times, failures)
qqplot.rga(fit)
}
\seealso{
Other goodness-of-fit: 
\code{\link{ppplot.rga}()}
}
\concept{goodness-of-fit}
