% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customize_table_body_function.R
\name{customize_table_body}
\alias{customize_table_body}
\title{Customize Table Body}
\usage{
customize_table_body(data)
}
\arguments{
\item{data}{A data frame that must contain at least two columns:
\itemize{
\item \code{stat_0}: A column whose missing (\code{NA}) values are to be replaced.
\item \code{n}: A column providing replacement values for \code{stat_0} when its values are missing.
}}
}
\value{
A modified data frame with:
\itemize{
\item Updated \code{stat_0} values (replaced with \code{n} values where \code{NA} is found).
\item The \code{n} column removed after integration.
}
}
\description{
This function modifies a data frame by updating the \code{stat_0} column. If any values in
\code{stat_0} are missing (\code{NA}), they are replaced by the values from the \code{n} column.
After the replacement, the \code{n} column is removed from the data frame.
}
\details{
\itemize{
\item The function uses \code{dplyr::case_when} to conditionally update the \code{stat_0} column.
\item After the replacement process, the \code{n} column is dropped using \code{dplyr::select(-n)}.
\item This function is particularly useful for cleaning and preparing table data.
}
}
\examples{
# Example data
data <- data.frame(
  stat_0 = c(NA, "B", "C"),
  n = c(10, 20, 30)
)

# Apply the function
modified_data <- customize_table_body(data)
print(modified_data)

}
