#' @title Example dataset
#' @description Geometric morphometrics shape data regarding mandible and
#'   phylogentic tree of 'Ungulatomorpha' (\cite{Raia et al., 2010}).
#' @name DataUng
#' @format A list containing: \describe{ \item{\strong{$PCscoresung}}{A data
#'   frame containing 205 shape variables for mandible of 'Ungulatomorpha'}.
#'   \item{\strong{$treeung}}{Phylogenetic tree of 'Ungulatomorpha'}.
#'   \item{\strong{$stateung}}{vector of 'Ungulatomorpha' feeding type}. }
#' @docType data
#' @author Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
#'   Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
#'   Carotenuto
#' @keywords RRphylo
#' @usage data(DataUng)
#' @references Raia, P., Carotenuto, F., Meloro, C., Piras, P., & Pushkina, D.
#'   (2010). The shape of contention: adaptation, history, and contingency in
#'   ungulate mandibles. \emph{Evolution}, 64: 1489-1503.
NULL
