/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataflowParser
implements Parser<List<Dataflow>> {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String DATAFLOW = "Dataflow";
    private static final String ID = "id";
    private static final String AGENCY = "agencyID";
    private static final String VERSION = "version";
    private static final String EXTERNAL = "isExternalReference";
    private static final String NAME = "Name";
    private static final String REF = "Ref";

    @Override
    public List<Dataflow> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException {
        ArrayList<Dataflow> arrayList = new ArrayList<Dataflow>();
        Dataflow dataflow = null;
        LocalizedText localizedText = new LocalizedText(list);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                String string;
                String string2;
                String string3;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == DATAFLOW) {
                    localizedText = new LocalizedText(list);
                    string3 = null;
                    string2 = null;
                    string = null;
                    boolean bl = false;
                    for (Object object : startElement::getAttributes) {
                        switch (object.getName().toString()) {
                            case "id": {
                                string3 = object.getValue();
                                break;
                            }
                            case "agencyID": {
                                string2 = object.getValue();
                                break;
                            }
                            case "version": {
                                string = object.getValue();
                                break;
                            }
                            case "isExternalReference": {
                                bl = object.getValue().equalsIgnoreCase("true");
                            }
                        }
                    }
                    if (bl) {
                        logger.fine("Dataflow: " + string2 + "," + string3 + "," + string + " has an externa reference");
                        continue;
                    }
                    dataflow = new Dataflow(string3, string2, string, localizedText);
                }
                if (startElement.getName().getLocalPart() == NAME) {
                    localizedText.setText(startElement, xMLEventReader);
                }
                if (startElement.getName().getLocalPart() != REF) continue;
                string3 = null;
                string2 = null;
                string = null;
                for (Object object : startElement::getAttributes) {
                    switch (object.getName().toString()) {
                        case "id": {
                            string3 = object.getValue();
                            break;
                        }
                        case "agencyID": {
                            string2 = object.getValue();
                            break;
                        }
                        case "version": {
                            string = object.getValue();
                        }
                    }
                }
                dataflow.setDsdIdentifier(new SDMXReference(string3, string2, string));
                continue;
            }
            if (!xMLEvent.isEndElement() || !DATAFLOW.equals(xMLEvent.asEndElement().getName().getLocalPart())) continue;
            arrayList.add(dataflow);
        }
        return arrayList;
    }
}

